﻿[//lasso
/*----------------------------------------------------------------------------

[weatherbug_getstations]
Returns a list of WeatherBug stations in a zip code.

Author: Jason Huck
Last Modified: May. 08, 2006
License: Artistic license <http://opensource.org/licenses/artistic-license.php>

Description:
Returns a list of WeatherBug stations in a zip code. Requires a valid 
WeatherBug API Key.


Sample Usage:
var('stations') = weatherbug_getstations(
	-key=$key,
	-zip=$zip
);

iterate($stations, local('s'));
	iterate(#s->keys, local('i'));
		#i + ': ' + #s->find(#i) + '<br>\n';
	/iterate;
	
	'<br>\n' * 2;
/iterate;


Downloaded from tagSwap.net on Feb. 14, 2007.
Latest version available from <http://tagSwap.net/weatherbug_getstations>.

----------------------------------------------------------------------------*/
		

define_tag(
	'getstations',
	-namespace='weatherbug_',
	-required='key',
	-required='zip',
	-priority='replace',
	-description='Returns a list of WeatherBug stations in a zip code.'
);
	local('url' = 'http://' + #key + '.api.wxbug.net/getStations.aspx');
	local('getparams') = array(
		'acode' = #key,
		'zipcode' = #zip
	);
	
	local('response') = include_url(
		#url,
		-getparams=#getparams
	);
	
	#response->replace(' xmlns:aws="http://www.aws.com/aws"','')&replace('aws:','');
	
	local('xmldata') = xml(#response);
	local('stations') = #xmldata->extract('//station');
	local('out' = array);
	
	local('fields') = array(
		'id',
		'name',
		'city',
		'state',
		'zipcode',
		'distance',
		'station-type'
	);
	
	iterate(#stations, local('s'));
		#s = xml('<?xml version="1.0" encoding="utf-8" ?>' + #s);
	
		local('map' = map);
		
		iterate(#fields, local('f'));
			local('v') = string(#s->extract('//@' + #f)->first)->split('="')->second;
			#v->removetrailing('"');
			#map->insert(#f = #v);
		/iterate;
		
		#out->insert(#map);
	/iterate;
	
	return(@#out);
/define_tag;
]
